/* Write functions.

Copyright (C) 1999 Politecnico di Torino

This file is part of the NDIS Packet capture driver.

The GNU C Library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public License as
published by the Free Software Foundation; either version 2 of the
License, or (at your option) any later version.

The GNU C Library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with the GNU C Library; see the file COPYING.LIB.  If
not, write to the Free Software Foundation, Inc., 675 Mass Ave,
Cambridge, MA 02139, USA.  */


#include "stdarg.h"
#include "ntddk.h"
#include "ntiologc.h"
#include "ndis.h"

#include "debug.h"
#include "packet.h"




//-------------------------------------------------------------------
NTSTATUS
PacketWrite(
    IN PDEVICE_OBJECT DeviceObject,
    IN PIRP Irp
    )

{
    POPEN_INSTANCE      Open;
    PIO_STACK_LOCATION IrpSp;
    PNDIS_PACKET       pPacket;

    NDIS_STATUS     Status;

    IF_LOUD(DbgPrint("Packet: SendAdapter\n");)

    IrpSp = IoGetCurrentIrpStackLocation(Irp);

    Open=IrpSp->FileObject->FsContext;
    //
    //  Try to get a packet from our list of free ones
    //

    NdisAllocatePacket(
        &Status,
        &pPacket,
        Open->PacketPool
        );

    if (Status != NDIS_STATUS_SUCCESS) {

        //
        //  No free packets
        //
        Irp->IoStatus.Status = STATUS_INSUFFICIENT_RESOURCES;
        IoCompleteRequest (Irp, IO_NO_INCREMENT);
        return STATUS_INSUFFICIENT_RESOURCES;
    }

    RESERVED(pPacket)->Irp=Irp;

    //
    //  Attach the writes buffer to the packet
    //
    NdisChainBufferAtFront(pPacket,Irp->MdlAddress);

    IoMarkIrpPending(Irp);

    //
    //  Call the MAC
    //
    NdisSend(
        &Status,
        Open->AdapterHandle,
        pPacket);


    if (Status != NDIS_STATUS_PENDING) {
        //
        //  The send didn't pend so call the completion handler now
        //
        PacketSendComplete(
            Open,
            pPacket,
            Status
            );
        return Status;

    }



    return(STATUS_PENDING);

}


//-------------------------------------------------------------------
VOID
PacketSendComplete(
    IN NDIS_HANDLE   ProtocolBindingContext,
    IN PNDIS_PACKET  pPacket,
    IN NDIS_STATUS   Status
    )

{
    PIRP              Irp;
    PIO_STACK_LOCATION  irpSp;

    IF_LOUD(DbgPrint("Packet: SendComplete\n");)

    Irp=RESERVED(pPacket)->Irp;
    irpSp = IoGetCurrentIrpStackLocation(Irp);

    //
    //  recyle the packet
    //
    NdisReinitializePacket(pPacket);

    //
    //  Put the packet back on the free list
    //
    NdisFreePacket(pPacket);

    Irp->IoStatus.Status = Status;
    Irp->IoStatus.Information = irpSp->Parameters.Write.Length;
    IoCompleteRequest(Irp, IO_NO_INCREMENT);

    return;

}
