/*Copyright (C) 1999 Politecnico di Torino

This file is part of the libpcap library for win32.

The GNU C Library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public License as
published by the Free Software Foundation; either version 2 of the
License, or (at your option) any later version.

The GNU C Library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with the GNU C Library; see the file COPYING.LIB.  If
not, write to the Free Software Foundation, Inc., 675 Mass Ave,
Cambridge, MA 02139, USA.


Portions Copyright (c) 1994, 1995, 1996, 1997, 1998
The Regents of the University of California.  All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
1. Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice, this list of conditions and the following disclaimer in the
   documentation and/or other materials provided with the distribution.
3. All advertising materials mentioning features or use of this software
   must display the following acknowledgement:
This product includes software developed by the Computer Systems
Engineering Group at Lawrence Berkeley Laboratory.
4. Neither the name of the University nor of the Laboratory may be used
   to endorse or promote products derived from this software without
   specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
SUCH DAMAGE.
*/

#ifndef lint
static const char rcsid[] =
    "@(#) $Header: inet.c,v 1.22 98/01/30 17:29:34 leres Exp $ (LBL)";
#endif

#include "pcap-int.h"

#ifndef WIN32 
#include <sys/param.h>
#include <sys/file.h>
#include <sys/ioctl.h>
#include <sys/socket.h>
#ifdef HAVE_SYS_SOCKIO_H
#include <sys/sockio.h>
#endif
#include <sys/time.h>				/* concession to AIX */
#else 
#include <windows.h>
#include <windef.h>
#include <winsock.h>
#include <packet32.h>
#endif

#if __STDC__
struct mbuf;
struct rtentry;
#endif

#include <net/if.h>

#ifndef WIN32 
#include <netinet/in.h>
#endif

#include <ctype.h>
#include <errno.h>
#include <memory.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include "gnuc.h"
#ifdef HAVE_OS_PROTO_H
#include "os-proto.h"
#endif

/* Not all systems have IFF_LOOPBACK */
#ifdef IFF_LOOPBACK
#define ISLOOPBACK(p) ((p)->ifr_flags & IFF_LOOPBACK)
#else
#define ISLOOPBACK(p) ((p)->ifr_name[0] == 'l' && (p)->ifr_name[1] == 'o' && \
    (isdigit((p)->ifr_name[2]) || (p)->ifr_name[2] == '\0'))
#endif

#ifdef WIN32
char *AdapterName1;
#endif


/*
 * Return the name of a network interface attached to the system, or NULL
 * if none can be found.  The interface must be configured up; the
 * lowest unit number is preferred; loopback is ignored.
 */
char *
pcap_lookupdev(errbuf)
	register char *errbuf;
{
#ifndef WIN32
	register int fd, minunit, n;
	register char *cp;
	register struct ifreq *ifrp, *ifend, *ifnext, *mp;
	struct ifconf ifc;
	struct ifreq ibuf[16], ifr;
	static char device[sizeof(ifrp->ifr_name) + 1];

	fd = socket(AF_INET, SOCK_DGRAM, 0);
	if (fd < 0) {
		(void)sprintf(errbuf, "socket: %s", pcap_strerror(errno));
		return (NULL);
	}
	ifc.ifc_len = sizeof ibuf;
	ifc.ifc_buf = (caddr_t)ibuf;

	memset((char *)ibuf, 0, sizeof(ibuf));
	if (ioctl(fd, SIOCGIFCONF, (char *)&ifc) < 0 ||
	    ifc.ifc_len < sizeof(struct ifreq)) 
	{
		(void)sprintf(errbuf, "SIOCGIFCONF: %s", pcap_strerror(errno));
		(void)close(fd);
		return (NULL);
	}
	ifrp = ibuf;
	ifend = (struct ifreq *)((char *)ibuf + ifc.ifc_len);

	mp = NULL;
	minunit = 666;
	for (; ifrp < ifend; ifrp = ifnext) {
#ifdef HAVE_SOCKADDR_SA_LEN
		n = ifrp->ifr_addr.sa_len + sizeof(ifrp->ifr_name);
		if (n < sizeof(*ifrp))
			ifnext = ifrp + 1;
		else
			ifnext = (struct ifreq *)((char *)ifrp + n);
		if (ifrp->ifr_addr.sa_family != AF_INET)
			continue;
#else
		ifnext = ifrp + 1;
#endif
		/*
		 * Need a template to preserve address info that is
		 * used below to locate the next entry.  (Otherwise,
		 * SIOCGIFFLAGS stomps over it because the requests
		 * are returned in a union.)
		 */
		strncpy(ifr.ifr_name, ifrp->ifr_name, sizeof(ifr.ifr_name));
		if (ioctl(fd, SIOCGIFFLAGS, (char *)&ifr) < 0) {
			if (errno == ENXIO)
				continue;
			(void)sprintf(errbuf, "SIOCGIFFLAGS: %.*s: %s",
			    (int)sizeof(ifr.ifr_name), ifr.ifr_name,
			    pcap_strerror(errno));
			(void)close(fd);
			return (NULL);
		}

		/* Must be up and not the loopback */
		if ((ifr.ifr_flags & IFF_UP) == 0 || ISLOOPBACK(&ifr))
			continue;

		for (cp = ifrp->ifr_name; !isdigit(*cp); ++cp)
			continue;
		n = atoi(cp);
		if (n < minunit) {
			minunit = n;
			mp = ifrp;
		}
	}
	(void)close(fd);
	if (mp == NULL) {
		(void)strcpy(errbuf, "no suitable device found");
		return (NULL);
	}

	(void)strncpy(device, mp->ifr_name, sizeof(device) - 1);
	device[sizeof(device) - 1] = '\0';
	return (device);
#else

DWORD dwVersion;
DWORD dwWindowsMajorVersion;
dwVersion=GetVersion();		//get the OS version
dwWindowsMajorVersion =  (DWORD)(LOBYTE(LOWORD(dwVersion)));


   if (dwVersion >= 0x80000000 && dwWindowsMajorVersion >= 4)			// Windows '95
   {
	ULONG NameLength = 1024;
    char AdaptersName[1024];
	int i;
	
	AdapterName1= (char*)malloc(1024*sizeof(char));
	PacketGetAdapterNames (AdaptersName,&NameLength);
	for (i=0;AdaptersName[i]!='\0';i++)
	{
		if (AdaptersName[i]==' ') AdapterName1[i]='\0';
		else AdapterName1[i] = AdaptersName[i];
	}
	AdapterName1[i] = '\0';
	AdapterName1[i+1] = '\0';
	AdapterName1[i+2] = '\0';

	return (AdapterName1);
   }
   else
   {
    ULONG NameLength = 1024;
    WCHAR AdaptersName[1024];
	int i;
	
	AdapterName1= (WCHAR*)malloc(1024*sizeof(WCHAR));
	PacketGetAdapterNames (AdaptersName,&NameLength);
	for (i=0;AdaptersName[i]!='\0' || AdaptersName[i+1]!='\0';i++)
	{
		*(((WCHAR*)AdapterName1)+i) = AdaptersName[i];
	}
	((WCHAR*)AdapterName1)[i] = '\0';
	((WCHAR*)AdapterName1)[i+1] = '\0';
	((WCHAR*)AdapterName1)[i+2] = '\0';

	return (char*)(AdapterName1);
   }
#endif
}


int
pcap_lookupnet(device, netp, maskp, errbuf)
	register char *device;
	register bpf_u_int32 *netp, *maskp;
	register char *errbuf;
{
#ifndef WIN32
	register int fd;
	register struct sockaddr_in *sin;
	struct ifreq ifr;

	fd = socket(AF_INET, SOCK_DGRAM, 0);
	if (fd < 0) {
		(void)sprintf(errbuf, "socket: %s", pcap_strerror(errno));
		return (-1);
	}
	memset(&ifr, 0, sizeof(ifr));
#ifdef linux
	/* XXX Work around Linux kernel bug */
	ifr.ifr_addr.sa_family = AF_INET;
#endif
	(void)strncpy(ifr.ifr_name, device, sizeof(ifr.ifr_name));
	if (ioctl(fd, SIOCGIFADDR, (char *)&ifr) < 0) 
	{
		(void)sprintf(errbuf, "SIOCGIFADDR: %s: %s",
		    device, pcap_strerror(errno));
		(void)close(fd);
		return (-1);
	}
	sin = (struct sockaddr_in *)&ifr.ifr_addr;
	*netp = sin->sin_addr.s_addr;
	if (ioctl(fd, SIOCGIFNETMASK, (char *)&ifr) < 0) {
		(void)sprintf(errbuf, "SIOCGIFNETMASK: %s: %s",
		    device, pcap_strerror(errno));
		(void)close(fd);
		return (-1);
	}
	(void)close(fd);
	*maskp = sin->sin_addr.s_addr;
	if (*maskp == 0) {
		if (IN_CLASSA(*netp))
			*maskp = IN_CLASSA_NET;
		else if (IN_CLASSB(*netp))
			*maskp = IN_CLASSB_NET;
		else if (IN_CLASSC(*netp))
			*maskp = IN_CLASSC_NET;
		else {
			(void)sprintf(errbuf, "inet class for 0x%x unknown",
			    *netp);
			return (-1);
		}
	}
	*netp &= *maskp;
	return (0);
#else 
	struct hostent* h;
	char szBuff[80];

    if(gethostname(szBuff, 79)) 
	{
		if(WSAGetLastError()==WSANOTINITIALISED){
			wsockinit();
			if(gethostname(szBuff, 79))
			{
				sprintf(errbuf, "Unknown host name");
				return -1;
			}
			h=gethostbyname(szBuff);
			*netp=((h->h_addr_list[0][0]<<24))+
			((h->h_addr_list[0][1]<<16))+
		    ((h->h_addr_list[0][2]<<8))+
		    ((h->h_addr_list[0][3]));
			if (((*netp)&0x80000000)==0) *maskp=0xFF000000;
			else if (((*netp)&0xC0000000)==0x80000000) *maskp=0xFFFF0000;
			else if (((*netp)&0xE0000000)==0xC0000000) *maskp=0xFFFFFF00;
			else {sprintf(errbuf, "Unknown netmask"); return -1;}
			(*netp)&=*maskp;
			return 0;

		}
		else
		{
		sprintf(errbuf, "Unknown host name");
		return -1;
		}
	}

	h=gethostbyname(szBuff);
	*netp=((h->h_addr_list[0][0]<<24))+
		  ((h->h_addr_list[0][1]<<16))+
		  ((h->h_addr_list[0][2]<<8))+
		  ((h->h_addr_list[0][3]));
	if (((*netp)&0x80000000)==0) *maskp=0xFF000000;
	else if (((*netp)&0xC0000000)==0x80000000) *maskp=0xFFFF0000;
	else if (((*netp)&0xE0000000)==0xC0000000) *maskp=0xFFFFFF00;
	else {sprintf(errbuf, "Unknown netmask"); return -1;}
	(*netp)&=*maskp;

	return 0;
#endif
}
