#include "stdafx.h"
#include "resource.h"
#include "capdll.h"
#include "console.h"

HANDLE in,out,err;

DWORD d;
CCapPars* pObject;
CRITICAL_SECTION Crit;

// callback routine called for every incoming packet
void dispatcher_handler(u_char *temp1,const struct pcap_pkthdr *header, const u_char *pkt_data)
{
int totpacketlen;

	totpacketlen=header->len;

	//the following line is needed because the packets generated
	//by the host where netmeter is running are passed to the 
	//program before being sent to the network, and therefore without 
	//the panning to reach the minimum ethernet packet length.
	if(totpacketlen<60)totpacketlen=60;

	// add preamble+SFD+FCS+interpacketgap to the packet
	// these values must be considered to calculate the network's load
	totpacketlen+=24;

	// update the value in the user interface task
	EnterCriticalSection(&Crit);
	pObject->prg->BytesCaptured+=header->len;
	LeaveCriticalSection(&Crit);

}

//main thread procedure: launches the capture and wait
UINT MyThreadProc( LPVOID pParam )
{   
	pObject = (CCapPars*)pParam;
    if (pObject == NULL)
    return -1;    // illegal parameter

	//get the semaphore
	Crit=pObject->Crit;

	//start the capture loop
	pcap_loop(pObject->fp, 0, dispatcher_handler, NULL);

	return d;
}

